#ifndef DEVPCIEINTDEFS_H
#define DEVPCIEINTDEFS_H
/*
// ==========================================================================
//
// = LIBRARY
//     shared/dev
// 
// = FILENAME
//    devpcieintdefs.h
//
// = COPYRIGHT
//    (C) Copyright Agilent Technologies 2003
//
// = Remarks: Keep this file OS independent (chris)
//
// ==========================================================================
*/

// the pre-processor define CHANGE_LONG_TO_INT will change
// longs to int. This define is not taken into account for
// WIN32 builds.
#ifndef WIN32

#ifdef CHANGE_LONG_TO_INT
typedef unsigned int UIntOrLong;
#else
typedef unsigned long UIntOrLong;
#endif

#else // #ifndef WIN32

//AN:GEN3_EX -> Define the features supported in PCIEGen3, used to avoid unnecessary register access's
//#define PCIE_GEN3_STATISTICS_SUPPORT
typedef unsigned long UIntOrLong;

#endif // #ifndef WIN32

#include "devmidl.h"

typedef DEV_MIDL_ENUM enum ExerciserPropertyChanged
{
  EXERCISER_PROPERTY_CHANGED_CONFIGSPACE,
  EXERCISER_PROPERTY_CHANGED_EXERCISER_STATUS_EVENT,
  EXERCISER_PROPERTY_CHANGED_DECODER,
  EXERCISER_PROPERTY_CHANGED_CONFIGSPACEPROP,
  EXERCISER_PROPERTY_CHANGED_VC,
  EXERCISER_PROPERTY_CHANGED_EXERCISER,
  EXERCISER_PROPERTY_CHANGED_DLLPHY,
  EXERCISER_PROPERTY_CHANGED_HWCHANNEL,
  EXERCISER_PROPERTY_CHANGED_LANESKEW,
  EXERCISER_PROPERTY_CHANGED_MULTIPLE,
  EXERCISER_PROPERTY_CHANGED_DLLP_PROP,
  EXERCISER_PROPERTY_CHANGED_DLLP_CONTROL,
  EXERCISER_PROPERTY_CHANGED_DLLP_STATUS,
} ExerciserPropertyChanged;

typedef DEV_MIDL_ENUM enum MultiplexedNotificationsChannel
{
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_LINKSTATE                        = 0,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_SI_SUCCESSFULLY_SENT             = 1,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_COMPLETION_AVAILABLE             = 2,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_COMPLETION_OTHER_THAN_SUCCESSFUL = 3,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_UNEXPECTED_COMPLETION            = 4,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_COMPLETION_TIMEOUT               = 5,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_UNSUPPORTED_REQUEST              = 6,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_DECODER_MISS                     = 7,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_BLOCKMEM_STATUS                  = 8,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_INVALID_CLOCK                    = 9,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_TRIGGEROUT                       = 10,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_GENERATOR_MISMATCH               = 11,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_MEM_MISMATCH                     = 12,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_LINKWIDTH                        = 13,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_LINKSPEED                        = 14,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_DATARATERECEIVED                 = 15,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_DATARATEADVERTISED               = 16,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_USB_COMMUNICATION_ERR            = 17,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_INVALID_REQUEST                  = 18,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_RX_POLARITY_REVERSAL             = 19,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_PROTERR                          = 20,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_POWERSTATE                       = 21,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_DLLP_DATA_SENT                   = 22,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_DLLP_WRONG_CRC_DONE              = 23,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_FC_REQ_RECIEVED                  = 24,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_VC_RESOURCE_1_INITIALIZED        = 25,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_MRIOV_VH1_INITIALIZED            = 26,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_MRIOV_VH2_INITIALIZED            = 27,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_MRIOV_VH3_INITIALIZED            = 28,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_MRIOV_NEG                        = 29,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_RESERVED01                       = 30,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_RESERVED02                       = 31,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_ENTRY_NUM                        = 32,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_MRIOV_VH4_INITIALIZED            = 33,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_RXPRESETHINT                     = 34,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_TXPRESETCOEFFCHANGED             = 35,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_INT_OPTION_CHANGED               = 36,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_DUT_CFG_REG_CHANGED              = 37,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_NVME_ADMIN_QUEUE_INIT_DONE       = 38,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_NVME_CONT_REG_CHANGED            = 39,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_NVME_SQ_COUNT_CHANGED            = 40,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_NVME_CQ_COUNT_CHANGED            = 41,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_NVME_SQ_DOORBELL_CHANGED         = 42,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_NVME_CQ_DOORBELL_CHANGED         = 43,
  MULTIPLEXED_NOTIFICATIONS_CHANNEL_NVME_CPL_RECEIVED                = 44
} MultiplexedNotificationsChannel;

const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_X1     = 0;
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_X4     = 1;
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_X8     = 2;

const UIntOrLong SOFTWARE_PACKAGE_ID_ANALYZER_X1      = 3;
const UIntOrLong SOFTWARE_PACKAGE_ID_ANALYZER_X4      = 4;
const UIntOrLong SOFTWARE_PACKAGE_ID_ANALYZER_X8      = 5;
const UIntOrLong SOFTWARE_PACKAGE_ID_ANALYZER_GHI_X1  = 6;

const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GHI_X1 = 7;

const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_X01 = 30; // Linkwidth  x1: 0x7E01: Exerciser board x1 for PCIe 8Gbps (U4305A-E01).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_X04 = 31; // Linkwidth  x4: 0x7E04: Exerciser board x4 for PCIe 8Gbps (U4305A-E04).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_X08 = 32; // Linkwidth  x8: 0x7E08: Exerciser board x8 for PCIe 8Gbps (U4305A-E08).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_X16 = 33; // Linkwidth x16: 0x7E16: Exerciser board x16 for PCIe 8Gbps (U4305A-E16).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_G02 = 34; // Gen2 Speed   : 0x7EA2: Exerciser software license for PCIe 5Gbps (U4305A-EX2, U4305U-EX2).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_G03 = 35; // Gen3 Speed   : 0x7EA3: Exerciser software license for PCIe 8Gbps (U4305A-EX3, U4305U_EX3, U4305U_E23).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_LT3 = 36; // LTSSM        : 0x7EB1: LTSSM software license (U4305A-LT3, U4305U-LT3).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_MR2 = 37; // MRIOV - Gen2 : 0x7EB2: Multi Root I/O Virtualization for PCIe 5Gbps (U4305A-MR2, U4305U-MR2).
//const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_MR3 = 38; // MRIOV - Gen3 : 0x7EB3: Multi Root I/O Virtualization for PCIe 8Gbps (U4305A-025, U4305U-025).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_ECR = 39; // ECRC         : 0x7EC1: Transaction layer end-to-end cyclic redundancy check (ECRC) software license (U4305A-022, U4305U-022).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_SR2 = 40; // SRIOV - Gen2 : 0x7EC2: Single Root I/O Virtualization software license for PCIe 5Gbps (U4305A-023, U4305U-023).
//const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_SR3 = 41; // SRIOV - Gen3 : 0x7EC3: Single Root I/O Virtualization for PCIe 8Gbps (U4305A-026, U4305U-026).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_2PF = 42; // 2 PF         : 0x7EC4: Software license to enable two additional physical functions (U4305A-024, U4305U-024).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_GEN3_PTC = 43; // PTC          : 0x7ED1: Protocol Test Card 3.0 software license (U4305A-021, U4305U-021).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_MR       = 44; // MRIOV - Gen3 : 0x7ED2: Multi Root I/O Virtualization software license (U4305A-025, U4305U-025).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_SR       = 45; // SRIOV - Gen3 : 0x7ED4: Single Root I/O Virtualization software license (U4305A-026, U4305U-026).
const UIntOrLong SOFTWARE_PACKAGE_ID_EXERCISER_NVME     = 46; // NVME         : 0x7ED5: NVMe host (root complex) exerciser license (U4305A-1FP, U4305U-1FP).

const UIntOrLong PCIE_EXERCISER_PROP_CHANGED_EVENT_PARAMNUM = 5;
const UIntOrLong PCIE_PROTOCOLCHECKER_EVENT_PARAMNUM        = 1;

const UIntOrLong PCIE_CONFIGSPACE_NOFBARS       = 0x6;
const UIntOrLong PCIE_NUM_CONFIGSPACE_DECODERS  = 0x8;
const UIntOrLong PCIE_NUM_CONFIGSPACE_FUNCTIONS = 0x5;
const UIntOrLong PCIE_NUM_VCRESOURCES           = 0x6;  // Should be same as PCIE_VC_RESOURCE_END
const UIntOrLong PCIE_NUM_FUNCTIONS             = 0xD;  // Should have the same value as PCIE_HWCHANNEL_FUNCTION_END
const UIntOrLong PCIE_NUM_FUNCTIONS_PCIE        = 0x5;
const UIntOrLong PCIE_NUM_COMP_QUEUES           = 0x5;  // Should have the same value as PCIE_COMPQUEUE_END

const UIntOrLong PCIE_BLOCKLINE_NUM   = 512;
const UIntOrLong PCIE_REQBEHLINE_NUM  = 512;
const UIntOrLong PCIE_COMPBEHLINE_NUM = 512;

const UIntOrLong PCIE_MAX_BLOCKPROP_NUM   = 50;
const UIntOrLong PCIE_MAX_REQBEHPROP_NUM  = 50;
const UIntOrLong PCIE_MAX_COMPBEHPROP_NUM = 50;

const UIntOrLong PCIE_BLOCKLINE_CHANNEL_SEPARATOR_BIT   = 20; // Assuming no more than 1Meg block lines !
const UIntOrLong PCIE_REQBEHLINE_CHANNEL_SEPARATOR_BIT  = 20; // Assuming no more than 1Meg reqbeh lines !
const UIntOrLong PCIE_COMPBEHLINE_CHANNEL_SEPARATOR_BIT = 20; // Assuming no more than 1Meg comp beh lines !

const UIntOrLong PCIE_VC_NUM          = 8;
const UIntOrLong PCIE_TC_AND_LANE_NUM = 8;
const UIntOrLong PCIE_GEN1_LANE_NUM   = 8;
const UIntOrLong PCIE_GEN2_LANE_NUM   = 16;
const UIntOrLong PCIE_TC_NUM          = 8;

const UIntOrLong PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_REAL_SIZE = 18;

const UIntOrLong PCIE_DATAMEM_COMPARE_DATA_EXPECTED_START_ADDR  = ( 0x1 << 20 );
const UIntOrLong PCIE_DATAMEM_COMPARE_DATA_EXPECTED_SIZE        = ( 0x1 << 19 );

const UIntOrLong PCIE_NUM_OF_PATTERN_TERMS = 4;

// Protocol checker
const UIntOrLong PCIE_NUM_OF_PROTOCOL_RULES     = 23;  // Keep consistent with enum EPCIEProtRule from devpciedefs.h
const UIntOrLong PCIE_MAXNUM_OF_PROTOCOL_RULES  = 0x100;
const UIntOrLong PCIE_MAXNUM_OF_VC_RULES        = 8;

const UIntOrLong PCIE_CONFIGSPACE_GEN2_IMPLEMENTED_SIZE       = 0x22C; //0x170 + 0x48 (Advanced Error) This means: Valid offsets are 0x0, 0x4, ... ,0x1b8
const UIntOrLong PCIE_CONFIGSPACE_GEN2_PCIE_SIZE              = 0x1b8; //0x170 + 0x48 (Advanced Error) This means: Valid offsets are 0x0, 0x4, ... ,0x1b8
const UIntOrLong PCIE_CONFIGSPACE_GEN3_SRIOV_IMPLEMENTED_SIZE = 0x1f8; //Valid offsets are 0x1bc, 0x1c0, ... ,0x1f8
const UIntOrLong PCIE_CONFIGSPACE_GEN3_MRIOV_IMPLEMENTED_SIZE = 0x220; //Valid offsets are 0x1bc, 0x1c0, ... ,0x220

const UIntOrLong PCIE_FT_INT_MAP_IMPLEMENTED_SIZE = 32; // Size of Function Table
const UIntOrLong PCIE_FT_VH_IMPLEMENTED_SIZE      = 52; // Size of one VH entry

// const UIntOrLong PCIE_LTSSM_SEQUENCER_MEMORY_SIZE = 0x20000;
// const UIntOrLong PCIE_LTSSM_STATE_NUM             = 64;
const UIntOrLong PCIE_LTSSM_SEQUENCER_MEMORY_SIZE   = 0x80000;
const UIntOrLong PCIE_LTSSM_STATE_NUM               = 128;

//********************************* PCIE Port *********************************
// These are the DW offsets into config space,
// used to implement the PCIE port for WIN32 and Linux.

// CAUTION: Module Number for IBM is (and must remain) fix at 0xc8/4  !!!!

const UIntOrLong PCIE_CFGPORT_DWSTART         =  0xAC/4;   // First entry

const UIntOrLong PCIE_CFGPORT_SCRATCH_PAD_0   =  0xAC/4;   // new for U4305A
const UIntOrLong PCIE_CFGPORT_SCRATCH_PAD_1   =  0xB0/4;   // new for U4305A
const UIntOrLong PCIE_CFGPORT_SCRATCH_PAD_2   =  0xB4/4;   // new for U4305A
const UIntOrLong PCIE_CFGPORT_SCRATCH_PAD_3   =  0xB8/4;   // new for U4305A

const UIntOrLong PCIE_CFGPORT_ISP_CONTROL     =  0xBC/4;   // new for U4305A

const UIntOrLong PCIE_CFGPORT_VERSION         =  0xC0/4;   // new for E2960B
const UIntOrLong PCIE_CFGPORT_STATUS_CTRL     =  0xC4/4;   // new for E2960B
const UIntOrLong PCIE_MODULENUMBER_FOR_IBM    =  0xC8/4;   // IBM          
const UIntOrLong PCIE_CFGPORT_ADDRESS         =  0xCC/4;
const UIntOrLong PCIE_CFGPORT_SIZE            =  0xD0/4;
const UIntOrLong PCIE_CFGPORT_VALUE           =  0xD4/4;
const UIntOrLong PCIE_CFGPORT_FPGA_STATUS_CTRL=  0xD8/4;   // new for E2960B
const UIntOrLong PCIE_CFGPORT_FPGA_ADDRESS    =  0xDC/4;   // new for E2960B
const UIntOrLong PCIE_CFGPORT_FPGA_VALUE      =  0xE0/4;   // new for E2960B
const UIntOrLong PCIE_CFGPORT_FPGA_ACK        =  0xE4/4;   // new for E2960B

const UIntOrLong PCIE_CFGPORT_DWEND           =  0xE4/4;   // Last entry

const UIntOrLong PCIE_PCIEPORT_REVID_OFFSET              = 0x8/4;
const UIntOrLong PCIE_PCIEPORT_REVID_MASK                = 0xff;

const UIntOrLong PCIE_PCIEPORT_REVID_E2960A              = 0x8;
const UIntOrLong PCIE_PCIEPORT_REVID_E2960B_HIGHLANDER   = 0x9;
const UIntOrLong PCIE_PCIEPORT_REVID_E2960B_CONDOR       = 0xa;
const UIntOrLong PCIE_PCIEPORT_REVID_U4305A_TRISUL       = 0xb;

const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_STATUS_MASK             = 0x3;
const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_STATUS_VAL_DEFAULT      = 0x0;
const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_STATUS_VAL_FPGA_ACCEPT  = 0x1;
const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_STATUS_VAL_API_EXECUTE  = 0x3;
const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_STATUS_VAL_DONE         = 0x2;

const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_ERRSTATUS_MASK      = 0xffff;
const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_ERRSTATUS_BITPOS    = 16;
const UIntOrLong PCIE_CFGPORT_STATUS_CTRL_ERRSTATUS_ERRVAL_OK = 0x0;

// assuming that the following values start at bitpos 0!
const UIntOrLong PCIE_CFGPORT_FPGA_STATUS_CTRL_MASK = 0x3;
const UIntOrLong PCIE_CFGPORT_FPGA_STATUS_CTRL_VAL_DEFAULT = 0x0;
const UIntOrLong PCIE_CFGPORT_FPGA_STATUS_CTRL_VAL_REQUEST = 0x1;
const UIntOrLong PCIE_CFGPORT_FPGA_STATUS_CTRL_VAL_GRANTED = 0x2;
const UIntOrLong PCIE_CFGPORT_FPGA_STATUS_CTRL_VAL_UNKOWN  = 0x3;

const UIntOrLong PCIE_CFGPORT_FPGA_ACK_STATUS_MASK = 0x1;
const UIntOrLong PCIE_CFGPORT_FPGA_ACK_STATUS_WAIT = 0x0;
const UIntOrLong PCIE_CFGPORT_FPGA_ACK_STATUS_DONE = 0x1;

const UIntOrLong PCIE_ESW_VERSION_MAJOR = 0x8;
const UIntOrLong PCIE_ESW_VERSION_MINOR = 0x3;
const UIntOrLong PCIE_ESW_VERSION_MAJOR_BIT_POS = 0x8;
const UIntOrLong PCIE_ESW_VERSION_MINOR_BIT_POS = 0x0;
const UIntOrLong PCIE_ESW_VERSION_MAJOR_MINOR_BITSIZE = 0x8;
const UIntOrLong PCIE_ESW_VERSION_MAJOR_MINOR_BITMASK = 0xFF;
const UIntOrLong PCIE_ESW_VERSION_IS_FOR_API_ENABLE_BIT_POS = 16;
const UIntOrLong PCIE_ESW_VERSION_IS_FOR_FPGA_ENABLE_BIT_POS = 17;
const UIntOrLong PCIE_ESW_VERSION_IS_FOR_FPGA_API_ENABLE_BIT_SIZE = 0x1;

const UIntOrLong PCIE_CFGSPC_MAXIMUM_LINKWIDTH_BITPOS    = 0x4;
const UIntOrLong PCIE_CFGSPC_MAXIMUM_LINKWIDTH_BITSIZE   = 0x6;

const UIntOrLong PCIE_CFGSPC_SUPPORTED_LINKSPEED_BITPOS  = 0x0;
const UIntOrLong PCIE_CFGSPC_SUPPORTED_LINKSPEED_BITSIZE = 0x4;

//*****************************************************************************

const UIntOrLong PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS = 256; 
// there is a copy of PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS in
// \ipmodel\host\system\sessions\PCIExpress\PCIAPI\AgtPCIEControl.h
// \ipmodel\host\system\sessions\PCIExpress\PCIAPI\PCIEFPGATxMemories.h
// \ipmodel\host\system\sessions\PCIExpress\PCIAPI\AgtPCIPort\PCIESiMgmt.h
// \ipmodel\host\system\sessions\PCIExpress\PCIAPI\AgtPCIPort\PCIEFPGACSPkt.h


//******************************* FPGA Offsets ********************************

#define PCIE_FPGA_CSMIS_OFFSET                        0x000000 // csmis


#define PCIE_FPGAOFFSET_CSMIS_EXERCISER_MODE          0x074

// moved to here from \ipdevice\embedded\pcieexe_gen2\framework\pcieeswcommon.h
const UIntOrLong PCIE_FPGATXBLOCKMEMA_OFFSET          = 0x200000; // csbma
const UIntOrLong PCIE_FPGATXBLOCKMEMB_OFFSET          = 0x204000; // csbmb
const UIntOrLong PCIE_FPGATXBLOCKMEMC_OFFSET          = 0x208000;
const UIntOrLong PCIE_FPGATXBLOCKMEMBVF1_OFFSET       = 0x20C000;
const UIntOrLong PCIE_FPGATXBLOCKMEMBVF2_OFFSET       = 0x210000;
const UIntOrLong PCIE_FPGATXBLOCKMEMCVF1_OFFSET       = 0x214000;
const UIntOrLong PCIE_FPGATXBLOCKMEMCVF2_OFFSET       = 0x218000;

const UIntOrLong PCIE_FPGATXBLOCKMEMD_OFFSET          = 0x21C000; // csbmb
const UIntOrLong PCIE_FPGATXBLOCKMEME_OFFSET          = 0x220000;
const UIntOrLong PCIE_FPGATXBLOCKMEMDVF1_OFFSET       = 0x224000;
const UIntOrLong PCIE_FPGATXBLOCKMEMDVF2_OFFSET       = 0x228000;
const UIntOrLong PCIE_FPGATXBLOCKMEMEVF1_OFFSET       = 0x22C000;
const UIntOrLong PCIE_FPGATXBLOCKMEMEVF2_OFFSET       = 0x230000;

const UIntOrLong PCIE_FPGATXREQBEHMEMA_OFFSET         = 0x280000; // csrba
const UIntOrLong PCIE_FPGATXREQBEHMEMB_OFFSET         = 0x284000; // csrbb
const UIntOrLong PCIE_FPGATXREQBEHMEMC_OFFSET         = 0x288000;
const UIntOrLong PCIE_FPGATXREQBEHMEMBVF1_OFFSET      = 0x28C000;
const UIntOrLong PCIE_FPGATXREQBEHMEMBVF2_OFFSET      = 0x290000;
const UIntOrLong PCIE_FPGATXREQBEHMEMCVF1_OFFSET      = 0x294000;
const UIntOrLong PCIE_FPGATXREQBEHMEMCVF2_OFFSET      = 0x298000;

const UIntOrLong PCIE_FPGATXREQBEHMEMD_OFFSET         = 0x29C000; // csrbb
const UIntOrLong PCIE_FPGATXREQBEHMEME_OFFSET         = 0x2A0000;
const UIntOrLong PCIE_FPGATXREQBEHMEMDVF1_OFFSET      = 0x2A4000;
const UIntOrLong PCIE_FPGATXREQBEHMEMDVF2_OFFSET      = 0x2A8000;
const UIntOrLong PCIE_FPGATXREQBEHMEMEVF1_OFFSET      = 0x2AC000;
const UIntOrLong PCIE_FPGATXREQBEHMEMEVF2_OFFSET      = 0x2B0000;

const UIntOrLong PCIE_FPGATXCOMPBEHMEM_QUEUE0_OFFSET  = 0x300000; // cscb1 
const UIntOrLong PCIE_FPGATXCOMPBEHMEM_QUEUE1_OFFSET  = 0x304000; // cscb2
const UIntOrLong PCIE_FPGATXCOMPBEHMEM_QUEUE2_OFFSET  = 0x308000; // cscb3
const UIntOrLong PCIE_FPGATXCOMPBEHMEM_QUEUE3_OFFSET  = 0x30C000; // cscb4
const UIntOrLong PCIE_FPGATXCOMPBEHMEM_QUEUE4_OFFSET  = 0x310000; // cscb5

const UIntOrLong PCIE_FPGA_CSPKT_OFFSET               = 0x4C0000;
const UIntOrLong PCIE_FPGA_CSDAT_OFFSET               = 0x380000;
const UIntOrLong PCIE_FPGA_CSSPC_OFFSET               = 0x540000;
const UIntOrLong PCIE_FPGA_CSPCIEINT_OFFSET           = 0x340000;

// PTC BIOS testing chip selects
const UIntOrLong PCIE_FPGA_CSMIS_DWOFFSET             = 0x000000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSPRM_DWOFFSET             = 0x010000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSPHY_DWOFFSET             = 0x020000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSDLL_RX_FRONT_DWOFFSET    = 0x030000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSDLL_TX_FRONT_DWOFFSET    = 0x040000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSFCL_RX_BACK_DWOFFSET     = 0x050000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSFCL_TX_BACK_DWOFFSET     = 0x060000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSEET_BACK_DWOFFSET        = 0x100000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSRST_DWOFFSET             = 0x120000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSEET_FRONT_DWOFFSET       = 0x140000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSCFG_DWOFFSET             = 0x180000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSCFG_MEM_DWOFFSET         = 0x190000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSLSM_DWOFFSET             = 0x1a0000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSLSM_VAL_DWOFFSET         = 0x1b0000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSDLL_TX_BACK_DWOFFSET     = 0x1d0000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSFCL_FRONT_DWOFFSET       = 0x1e0000; // DW address (for PTC BIOS testing)!!
const UIntOrLong PCIE_FPGA_CSPTC_DWOFFSET             = 0x1f0000; // DW address (for PTC BIOS testing)!!

// CSPTC offsets
const UIntOrLong PCIE_FPGA_CSPTC_CFG_CTRL             = PCIE_FPGA_CSPTC_DWOFFSET + 0x2029; // DW address (for BIOS testing)
const UIntOrLong PCIE_FPGA_CSPTC_CFG_STATUS           = PCIE_FPGA_CSPTC_DWOFFSET + 0x202A; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_REQ_HEADER_DW0   = PCIE_FPGA_CSPTC_DWOFFSET + 0x202B; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_REQ_HEADER_DW1   = PCIE_FPGA_CSPTC_DWOFFSET + 0x202C; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_REQ_HEADER_DW2   = PCIE_FPGA_CSPTC_DWOFFSET + 0x202D; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_REQ_DATA         = PCIE_FPGA_CSPTC_DWOFFSET + 0x202E; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_COMPL_HEADER_DW0 = PCIE_FPGA_CSPTC_DWOFFSET + 0x202F; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_COMPL_HEADER_DW1 = PCIE_FPGA_CSPTC_DWOFFSET + 0x2030; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_COMPL_HEADER_DW2 = PCIE_FPGA_CSPTC_DWOFFSET + 0x2031; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_COMPL_DATA       = PCIE_FPGA_CSPTC_DWOFFSET + 0x2032; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_BIOS_STATUS          = PCIE_FPGA_CSPTC_DWOFFSET + 0x2040; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_COMPL_TIMEOUT        = PCIE_FPGA_CSPTC_DWOFFSET + 0x2041; // DW address
const UIntOrLong PCIE_FPGA_CSPTC_CFG_TIMEOUT          = PCIE_FPGA_CSPTC_DWOFFSET + 0x2042; // DW address

// CSPKT
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_TXCTRL                 = 0x000;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_TXCTRL_EXTENDED        = 0x0A0; 
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_TX_PKT_STATUS          = 0x004;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_TX_PKT_STATUS_EXTENDED = 0x0A4;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_A_POINTERS       = 0x008;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_B_POINTERS       = 0x00c;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_C_POINTERS       = 0x064;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_BVF1_POINTERS    = 0x068;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_BVF2_POINTERS    = 0x06C;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_CVF1_POINTERS    = 0x070;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_CVF2_POINTERS    = 0x074;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_D_POINTERS       = 0x0A8;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_E_POINTERS       = 0x0AC;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_DVF1_POINTERS    = 0x0B0;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_DVF2_POINTERS    = 0x0B4;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_EVF1_POINTERS    = 0x0B8;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_EVF2_POINTERS    = 0x0BC;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_A_POINTERS      = 0x010;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_B_POINTERS      = 0x014;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_C_POINTERS      = 0x078;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_BVF1_POINTERS   = 0x07C;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_BVF2_POINTERS   = 0x080;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_CVF1_POINTERS   = 0x084;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_CVF2_POINTERS   = 0x088;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_D_POINTERS     = 0x0C0;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_E_POINTERS     = 0x0C4;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_DVF1_POINTERS  = 0x0C8;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_DVF2_POINTERS  = 0x0CC;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_EVF1_POINTERS  = 0x0D0;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_EVF2_POINTERS  = 0x0D4;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQCOMPL_QUEUE0_POINTERS   = 0x018;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQCOMPL_QUEUE1_POINTERS   = 0x01c;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQCOMPL_QUEUE2_POINTERS   = 0x0D8;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQCOMPL_QUEUE3_POINTERS   = 0x0DC;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQCOMPL_QUEUE4_POINTERS   = 0x0FC;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_REPEAT_FIRST     = 0x020;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_REPEAT_SECOND    = 0x08C;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_REPEAT_THIRD     = 0x090;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_REPEAT_FOURTH    = 0x0E0;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_BLOCK_REPEAT_FIFTH     = 0x0E4;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_REPEAT_FIRST   = 0x024;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_REPEAT_SECOND  = 0x094;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_REPEAT_THIRD   = 0x098;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_REPEAT_FOURTH  = 0x0E8;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_REQBEH_REPEAT_FIFTH   = 0x0EC;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_COMPLBEH_REPEAT_FIRST  = 0x028;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_COMPLBEH_REPEAT_SECOND = 0x0F0;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_COMPLDELAY_QUEUE0     = 0x02c;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_COMPLDELAY_QUEUE1     = 0x030;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_COMPLDELAY_QUEUE2     = 0x0F4;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_COMPLDELAY_QUEUE3     = 0x0F8;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_COMPLDELAY_QUEUE4     = 0x0100;

const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_CTRL               = 0x034;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_INT_ADDR           = 0x038;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_HEADER0            = 0x03c;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_HEADER1            = 0x040;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_HEADER2            = 0x044;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_HEADER3            = 0x048;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_DATADW0            = 0x04c;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_DATADW1            = 0x050;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_DATADW2            = 0x054;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_SI_DATADW3            = 0x058;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_RESERVED              = 0x05C;
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_TXN_STATUS_HW_CHANNELS= 0x060; // txn status for h/w channels C,BVF1,BVF2,CVF1,CVF2
const UIntOrLong PCIE_FPGAOFFSET_CSPKT_IND_START_STOP_CTRL   = 0x09C; //for individual start and stop

// CSDAT //////////////////////////////////////////////////////////////////////
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_HOTACCESSCONTROL      = 0X000;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_HOTACCESSDATABE       = 0X004;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_HOTACCESSSTATUS       = 0X008;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_HOTACCESSRDDW0        = 0X00C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_HOTACCESSWRDW0        = 0X02C;
// Mem Compare - Function A
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_A_CTRL        = 0X050;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_A_STATUS      = 0X054;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_A_ERRCOUNT    = 0X058;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_A_REFCOUNT    = 0X05C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_A_ACTUAL      = 0X060;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_A_EXPECTED    = 0X064;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_A_BEADDR      = 0X068;
// Mem Compare - Function B
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_B_CTRL        = 0X06C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_B_STATUS      = 0X070;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_B_ERRCOUNT    = 0X074;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_B_REFCOUNT    = 0X078;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_B_ACTUAL      = 0X07C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_B_EXPECTED    = 0X080;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_B_BEADDR      = 0X084;
// Mem Compare - Function C
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_C_CTRL        = 0X088;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_C_STATUS      = 0X08C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_C_ERRCOUNT    = 0X090;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_C_REFCOUNT    = 0X094;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_C_ACTUAL      = 0X098;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_C_EXPECTED    = 0X09C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_C_BEADDR      = 0X0A0;
// Mem Compare - Function D
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_D_CTRL        = 0X114;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_D_STATUS      = 0X118;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_D_ERRCOUNT    = 0X11C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_D_REFCOUNT    = 0X120;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_D_ACTUAL      = 0X124;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_D_EXPECTED    = 0X128;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_D_BEADDR      = 0X12C;
// Mem Compare - Function E
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_E_CTRL        = 0X130;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_E_STATUS      = 0X134;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_E_ERRCOUNT    = 0X138;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_E_REFCOUNT    = 0X13C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_E_ACTUAL      = 0X140;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_E_EXPECTED    = 0X144;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_E_BEADDR      = 0X148;
// Mem Compare - Function BVF1
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF1_CTRL     = 0X0A4;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF1_STATUS   = 0X0A8;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF1_ERRCOUNT = 0X0AC;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF1_REFCOUNT = 0X0B0;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF1_ACTUAL   = 0X0B4;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF1_EXPECTED = 0X0B8;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF1_BEADDR   = 0X0BC;
// Mem Compare - Function BVF2
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF2_CTRL     = 0X0C0;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF2_STATUS   = 0X0C4;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF2_ERRCOUNT = 0X0C8;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF2_REFCOUNT = 0X0CC;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF2_ACTUAL   = 0X0D0;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF2_EXPECTED = 0X0D4;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_BVF2_BEADDR   = 0X0D8;
// Mem Compare - Function CVF1
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF1_CTRL     = 0X0DC;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF1_STATUS   = 0X0E0;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF1_ERRCOUNT = 0X0E4;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF1_REFCOUNT = 0X0E8;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF1_ACTUAL   = 0X0EC;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF1_EXPECTED = 0X0F0;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF1_BEADDR   = 0X0F4;
// Mem Compare - Function CVF2
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF2_CTRL     = 0X0F8;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF2_STATUS   = 0X0FC;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF2_ERRCOUNT = 0X100;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF2_REFCOUNT = 0X104;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF2_ACTUAL   = 0X108;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF2_EXPECTED = 0X10C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_CVF2_BEADDR   = 0X110;
// Mem Compare - Function DVF1
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF1_CTRL     = 0X14C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF1_STATUS   = 0X150;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF1_ERRCOUNT = 0X154;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF1_REFCOUNT = 0X158;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF1_ACTUAL   = 0X15C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF1_EXPECTED = 0X160;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF1_BEADDR   = 0X164;
// Mem Compare - Function DVF2
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF2_CTRL     = 0X168;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF2_STATUS   = 0X16C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF2_ERRCOUNT = 0X170;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF2_REFCOUNT = 0X174;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF2_ACTUAL   = 0X178;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF2_EXPECTED = 0X17C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_DVF2_BEADDR   = 0X180;
// Mem Compare - Function EVF1
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF1_CTRL     = 0X184;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF1_STATUS   = 0X188;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF1_ERRCOUNT = 0X18C;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF1_REFCOUNT = 0X190;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF1_ACTUAL   = 0X194;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF1_EXPECTED = 0X198;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF1_BEADDR   = 0X19C;
// Mem Compare - Function EVF2
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF2_CTRL     = 0X1A0;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF2_STATUS   = 0X1A4;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF2_ERRCOUNT = 0X1A8;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF2_REFCOUNT = 0X1AC;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF2_ACTUAL   = 0X1B0;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF2_EXPECTED = 0X1B4;
const UIntOrLong PCIE_FPGAOFFSET_CSDAT_MEMCOMP_EVF2_BEADDR   = 0X1B8;
///////////////////////////////////////////////////////////////////////////////

// CSSPC
const UIntOrLong PCIE_FPGAOFFSET_CSSPC_SICOMPLSTATUS         = 0x000;
const UIntOrLong PCIE_FPGAOFFSET_CSSPC_SICOMPLHEADERDW0      = 0x004;
const UIntOrLong PCIE_FPGAOFFSET_CSSPC_SICOMPLHEADERDW1      = 0x008;
const UIntOrLong PCIE_FPGAOFFSET_CSSPC_SICOMPLHEADERDW2      = 0x00c;
const UIntOrLong PCIE_FPGAOFFSET_CSSPC_SICOMPLHEADERDW3      = 0x010;
const UIntOrLong PCIE_FPGAOFFSET_CSSPC_SICOMPLPAYLOADDW0     = 0x014;

//*****************************************************************************

//***************************** Data Mem Access *******************************

// please be aware that this is the start address for special address range; see end of file
const UIntOrLong PCIE_DATAMEM_SIZE_GEN2_REL1 = 0x00020000; // 128kByte
const UIntOrLong PCIE_DATAMEM_SIZE_GEN2_REL2 = 0x00040000; // 256kByte

const UIntOrLong PCIE_DATAMEM_SIZE      = 0x00200000;
const UIntOrLong PCIE_DATAMEMSTART_ADDR = 0x20000000;


//******************************* Capture Mem Access **************************

// Offset
const UIntOrLong PCIE_CAPTUREMEM_OFFSET_ADDR = 0x007C0000; // FPGA offset

// Memories
const UIntOrLong PCIE_CAPTUREMEM_TLPDATA_ADDR   = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x0000;
const UIntOrLong PCIE_CAPTUREMEM_TLPDATA_SIZE   = 0x2000; // 8KB TLP packet headers
const UIntOrLong PCIE_CAPTUREMEM_DLLPDATA_ADDR  = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x2000;
const UIntOrLong PCIE_CAPTUREMEM_DLLPDATA_SIZE  = 0x2000; // 8KB DLLP packets
const UIntOrLong PCIE_CAPTUREMEM_TLPSTAMP_ADDR  = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x4000;
const UIntOrLong PCIE_CAPTUREMEM_TLPSTAMP_SIZE  = 0x800; // 2KB (!!!) TLP timestamps
const UIntOrLong PCIE_CAPTUREMEM_DLLPSTAMP_ADDR = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x6000;
const UIntOrLong PCIE_CAPTUREMEM_DLLPSTAMP_SIZE = 0x2000; // 8KB DLLP timestamps
const UIntOrLong PCIE_CAPTUREMEM_TLPQUAL_ADDR   = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8000;
const UIntOrLong PCIE_CAPTUREMEM_TLPQUAL_SIZE   = 0x0040; // 16 DW
const UIntOrLong PCIE_CAPTUREMEM_DLLPQUAL_ADDR  = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8040;
const UIntOrLong PCIE_CAPTUREMEM_DLLPQUAL_SIZE  = 0x0040; // 16 DW

// Registers
const UIntOrLong PCIE_CAPTUREMEM_STATUS_ADDR       = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8080;
const UIntOrLong PCIE_CAPTUREMEM_RESET_ADDR        = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8084;
const UIntOrLong PCIE_CAPTUREMEM_ENABLE_ADDR       = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8088;
const UIntOrLong PCIE_CAPTUREMEM_TLPSTATUS_ADDR    = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x808c;
const UIntOrLong PCIE_CAPTUREMEM_DLLPSTATUS_ADDR   = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8090;
const UIntOrLong PCIE_CAPTUREMEM_PATTSEL_ADDR      = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8094;
const UIntOrLong PCIE_CAPTUREMEM_PATTCFG_ADDR      = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x8098;
const UIntOrLong PCIE_CAPTUREMEM_PATTENABLE_ADDR   = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x809c;
const UIntOrLong PCIE_CAPTUREMEM_CONNECTOR_ADDR    = PCIE_CAPTUREMEM_OFFSET_ADDR + 0x80a0;

//*****************************************************************************

const UIntOrLong PCIE_INTERRUPT_DEBUG_BASE_ADDR   = 0x30000000;
const UIntOrLong PCIE_FPGA0_INTERRUPT0_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR;
const UIntOrLong PCIE_FPGA0_INTERRUPT1_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x4;
const UIntOrLong PCIE_FPGA0_INTERRUPT2_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x8;
const UIntOrLong PCIE_FPGA0_INTERRUPT3_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0xc;
const UIntOrLong PCIE_FPGA1_INTERRUPT0_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x10;
const UIntOrLong PCIE_FPGA1_INTERRUPT1_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x14;
const UIntOrLong PCIE_FPGA1_INTERRUPT2_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x18;
const UIntOrLong PCIE_FPGA1_INTERRUPT3_DEBUG_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x1c;

// TBD Move this to EPCIEExerciserStatus ASAP
const UIntOrLong PCIE_IN_SYSTEMPORT_STATUS_ADDR                          = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x100;
const UIntOrLong PCIE_IN_SYSTEMPORT_AT_LEAST_ONE_FPGA_ACCESS_FAILED_ADDR = PCIE_INTERRUPT_DEBUG_BASE_ADDR + 0x104;

//***************************** Enum sizes ************************************
const UIntOrLong PCIE_CONFIGSPACE_SIZE                          = 0x00001000; 
const UIntOrLong PCIE_CONFIGSPACE_PROP_SIZE                     = 20;
const UIntOrLong PCIE_DECODERBAR_SIZE                           = 20; // With reference to enum EPCIEDecProp
const UIntOrLong PCIE_EXERCISER_SIZE                            = 50; // Should be greater than max possible value of EPCIEExerciser
const UIntOrLong PCIE_NUMDECFUNCTIONS                           = 5;
const UIntOrLong PCIE_SI_REQ_PROP_SIZE                          = 52;   // very tight ! (real size is 51!)
const UIntOrLong PCIE_SI_REQ_PYLD_SIZE                          = 0x10; // 16 bytes, 4 DW
const UIntOrLong PCIE_SI_COMP_PROP_SIZE                         = 48;   // impossible, but last 4 params make no sense anyway, see SiCompGet
const UIntOrLong PCIE_SI_COMP_PYLD_SIZE                         = 0x10; // 16 bytes, 4 DW
const UIntOrLong PCIE_TXSTATUS_SIZE                             = 50;
const UIntOrLong PCIE_RXSTATUS_SIZE                             = 50;
const UIntOrLong PCIE_DATAERRORSTATUS_SIZE                      = 10;
const UIntOrLong PCIE_PROTOCOLERRORSTATUS_SIZE                  = 30;
const UIntOrLong PCIE_VC_STATE_SIZE                             = 8;
const UIntOrLong PCIE_LANESKEW_SIZE                             = 8;
const UIntOrLong PCIE_HWCHANNEL_FUNCTION_PROP_SIZE              = 20;
const UIntOrLong PCIE_HWCHANNELSTATUS_PROP_SIZE                 = 30;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_SIZE                    = 20;
const UIntOrLong PCIE_DLLPHY_PROP_SIZE                          = 100;
const UIntOrLong PCIE_STATISTICSSTATUS_SIZE                     = 20;
const UIntOrLong PCIE_REQBEHLINECOUNTGET_SIZE                   = 20;
const UIntOrLong PCIE_COMPBEHLINECOUNTGET_SIZE                  = 20;
const UIntOrLong PCIE_INSTALLSWPACKAGE_SIZE                     = 30;
const UIntOrLong PCIE_CHECKSWPACKAGE_SIZE                       = 50;
const UIntOrLong PCIE_EXERCISER_BLOCK_SIZE                      = 20;
const UIntOrLong PCIE_EXERCISER_REQBEH_SIZE                     = 20;
const UIntOrLong PCIE_EXERCISER_COMPBEH_SIZE                    = 20;
const UIntOrLong PCIE_LASTERROR_STRING_SIZE                     = 256;
const UIntOrLong PCIE_PROBEBOARD_SERIALSTRING_SIZE              = 256;
const UIntOrLong PCIE_VCPROP_SIZE                               = 10;
const UIntOrLong PCIE_CONFIGSPACEPROP_SIZE                      = 200;
const UIntOrLong PCIE_LINKSTATE_DIRECT_SIZE                     = 30;
const UIntOrLong PCIE_RXERROR_SIZE                              = 30;
const UIntOrLong PCIE_RXERRORSTATUS_SIZE                        = 30;
const UIntOrLong PCIE_FPGAINFO_SIZE                             = 10;
const UIntOrLong PCIE_EXERCISERSTATUS_SIZE                      = 200;
const UIntOrLong PCIE_PERFORMANCE_COUNTER_STATUS_PROP_SIZE      = 30;
const UIntOrLong PCIE_PATTERN_MASK_SIZE                         = 70;
const UIntOrLong PCIE_PATTERN_VALUE_SIZE                        = PCIE_PATTERN_MASK_SIZE;
const UIntOrLong PCIE_MODULE_SIZE                               = 30;
const UIntOrLong PCIE_SI_REQ_PYLD_DW_SIZE                       = PCIE_SI_REQ_PYLD_SIZE / 4;
const UIntOrLong PCIE_SI_COMP_PYLD_DW_SIZE                      = PCIE_SI_COMP_PYLD_SIZE / 4;
const UIntOrLong PCIE_PROBEBOARD_SIZE                           = 30;
const UIntOrLong PCIE_PROBEBOARDEXECUTE_SIZE                    = 30;
const UIntOrLong PCIE_TRIGGEROUTSET_SIZE                        = 30;
const UIntOrLong PCIE_TRIGGEROUTGET_SIZE                        = 30;
const UIntOrLong PCIE_TRIGGEROUTSTATUSREAD_SIZE                 = 30;
const UIntOrLong PCIE_TRIGGEROUTSTATUSCLEAR_SIZE                = 1;
const UIntOrLong PCIE_SISTATUS_SIZE                             = 30;
const UIntOrLong PCIE_PROTRULE_ACCU_SIZE                        = PCIE_MAXNUM_OF_PROTOCOL_RULES;
const UIntOrLong PCIE_PROTRULE_FIRST_SIZE                       = PCIE_MAXNUM_OF_PROTOCOL_RULES;
const UIntOrLong PCIE_PROTRULE_CLEAR_SIZE                       = 1;
const UIntOrLong PCIE_PROTRULE_MASK_SIZE                        = PCIE_MAXNUM_OF_PROTOCOL_RULES;
const UIntOrLong PCIE_PROTRULE_VC_ACCU_SIZE                     = PCIE_MAXNUM_OF_VC_RULES;
const UIntOrLong PCIE_PROTRULE_VC_FIRST_SIZE                    = PCIE_MAXNUM_OF_VC_RULES;
const UIntOrLong PCIE_PROTRULE_VC_MASK_SIZE                     = PCIE_MAXNUM_OF_VC_RULES;
const UIntOrLong PCIE_PROTRULE_FUNCTION_ACCU_SIZE               = PCIE_NUM_FUNCTIONS;
const UIntOrLong PCIE_PROTRULE_FUNCTION_FIRST_SIZE              = PCIE_NUM_FUNCTIONS;
const UIntOrLong PCIE_PROTRULE_FUNCTION_MASK_SIZE               = PCIE_NUM_FUNCTIONS;
const UIntOrLong PCIE_PROTRULE_RESERVED_SIZE                    = 0x1000;
const UIntOrLong PCIE_MODULEINFO_SIZE                           = 50;
const UIntOrLong PCIE_ICACCESS_SIZE                             = 128;// the i2c bus is only 7 bits in size ! 
const UIntOrLong PCIE_DLLP_PROP_SIZE                            = 60;
const UIntOrLong PCIE_DLLP_STATUS_SIZE                          = 60;
const UIntOrLong PCIE_DLLP_CONTROL_SIZE                         = 60;
const UIntOrLong PCIE_LANESKEW2_SIZE                            = 16;
const UIntOrLong PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_SIZE = 60;
const UIntOrLong PCIE_LTSSM_MEMORY_IMAGE_HEADER_SIZE            = 0x10; // 4 dwords
const UIntOrLong PCIE_EXERCISERPHYSTATUS_SIZE                   = 30;
const UIntOrLong PCIE_EXERCISERCHANNELFUNCTIONGET_SIZE          = 60;
const UIntOrLong PCIE_EXERCISERCHANNELFUNCTIONSET_SIZE          = 60;

//const UIntOrLong PCIE_LTSSM_MEMORY_IMAGE_SIZE = PCIE_LTSSM_SEQUENCER_MEMORY_SIZE + PCIE_LTSSM_MEMORY_IMAGE_HEADER_SIZE + (PCIE_LTSSM_STATE_NUM * 4 * 2); // 128k + 4 dwords header information (e.g. version info) + 64 * 2 DWords MemoryA and MemoryB
const UIntOrLong PCIE_LTSSM_MEMORY_IMAGE_SIZE                   = PCIE_LTSSM_SEQUENCER_MEMORY_SIZE + PCIE_LTSSM_MEMORY_IMAGE_HEADER_SIZE + (PCIE_LTSSM_STATE_NUM * 4 * 3); // 128k + 4 dwords header information (e.g. version info) + 128 * 3 DWords MemoryA(64 bit) and MemoryB(32 bit)
const UIntOrLong PCIE_LTSSM_LA_CONTROL_SIZE                     = 50;
const UIntOrLong PCIE_LTSSM_LA_STATUS_SIZE                      = 50;
const UIntOrLong PCIE_LTSSM_LA_SIZE                             = 100;
const UIntOrLong PCIE_CAPTURE_SIZE                              = 50;
const UIntOrLong PCIE_CAPTURE_PATTPROG_SIZE                     = 1;
const UIntOrLong PCIE_CAPTURE_PATTSET_SIZE                      = 1;
const UIntOrLong PCIE_CAPTURE_PATTGET_SIZE                      = 1;
const UIntOrLong PCIE_HOST_CONTROLLER_VERSION_SIZE              = 4;
const UIntOrLong PCIE_SERIAL_NUMBER_STRING_SIZE                 = 4; /* 16 characters maximum, currently 12 characters, e.g. DEWHB0018-70*/
const UIntOrLong PCIE_FT_SIZE                                   = 5 * PCIE_FT_VH_IMPLEMENTED_SIZE + PCIE_FT_INT_MAP_IMPLEMENTED_SIZE;

//********************** Register Addresses for calls *************************

// This first entry is needed for range checking in pciehwcontrol.cpp
const UIntOrLong PCIE_CMD_FIRSTADDR                                 = 0x40000000;

const UIntOrLong PCIE_CONFIGSPACE_ADDR                              = PCIE_CMD_FIRSTADDR;
const UIntOrLong PCIE_CONFIGSPACE_MASK_ADDR                         = PCIE_CONFIGSPACE_ADDR         + PCIE_CONFIGSPACE_SIZE;
const UIntOrLong PCIE_CONFIGSPACE_PROP_ADDR                         = PCIE_CONFIGSPACE_MASK_ADDR    + PCIE_CONFIGSPACE_SIZE;
const UIntOrLong PCIE_CONFIGSPACE_PROP_ADDR_END                     = PCIE_CONFIGSPACE_PROP_ADDR    + PCIE_CONFIGSPACE_SIZE;

const UIntOrLong PCIE_ADDR_DECFUNC_A                                = PCIE_CONFIGSPACE_PROP_ADDR_END;
const UIntOrLong PCIE_ADDR_DECFUNC_B                                = PCIE_ADDR_DECFUNC_A           + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_C                                = PCIE_ADDR_DECFUNC_B           + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_D                                = PCIE_ADDR_DECFUNC_C           + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_E                                = PCIE_ADDR_DECFUNC_D           + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_BVF1                             = PCIE_ADDR_DECFUNC_E           + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_BVF2                             = PCIE_ADDR_DECFUNC_BVF1        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_CVF1                             = PCIE_ADDR_DECFUNC_BVF2        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_CVF2                             = PCIE_ADDR_DECFUNC_CVF1        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_DVF1                             = PCIE_ADDR_DECFUNC_CVF2        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_DVF2                             = PCIE_ADDR_DECFUNC_DVF1        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_EVF1                             = PCIE_ADDR_DECFUNC_DVF2        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_EVF2                             = PCIE_ADDR_DECFUNC_EVF1        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);
const UIntOrLong PCIE_ADDR_DECFUNC_END                              = PCIE_ADDR_DECFUNC_EVF2        + (PCIE_NUM_CONFIGSPACE_DECODERS * PCIE_DECODERBAR_SIZE);

const UIntOrLong PCIE_EXERCISER_ADDR                                = PCIE_ADDR_DECFUNC_END         + PCIE_CONFIGSPACE_PROP_SIZE;

const UIntOrLong PCIE_SI_REQ_PROP_ADDR                              = PCIE_EXERCISER_ADDR           + PCIE_EXERCISER_SIZE; 
const UIntOrLong PCIE_SI_REQ_PYLD_ADDR                              = PCIE_SI_REQ_PROP_ADDR         + PCIE_SI_REQ_PROP_SIZE;
const UIntOrLong PCIE_SI_COMP_PROP_ADDR                             = PCIE_SI_REQ_PYLD_ADDR         + PCIE_SI_REQ_PYLD_SIZE;
const UIntOrLong PCIE_SI_COMP_PYLD_ADDR                             = PCIE_SI_COMP_PROP_ADDR        + PCIE_SI_COMP_PROP_SIZE;
const UIntOrLong PCIE_SI_SEND_ADDR                                  = PCIE_SI_COMP_PYLD_ADDR        + PCIE_SI_COMP_PYLD_SIZE;
const UIntOrLong PCIE_SI_DEFAULT_ADDR                               = PCIE_SI_SEND_ADDR             + 1;

const UIntOrLong PCIE_TXSTATUS_ADDR                                 = PCIE_SI_DEFAULT_ADDR          + 1;
const UIntOrLong PCIE_RXSTATUS_ADDR                                 = PCIE_TXSTATUS_ADDR            + PCIE_TXSTATUS_SIZE;

const UIntOrLong PCIE_DATAERRORSTATUS_ADDR                          = PCIE_RXSTATUS_ADDR            + PCIE_RXSTATUS_SIZE;
const UIntOrLong PCIE_PROTOCOLERRORSTATUS_ADDR                      = PCIE_DATAERRORSTATUS_ADDR     + PCIE_DATAERRORSTATUS_SIZE;

const UIntOrLong PCIE_LINKWIDTHSTATUS_ADDR                          = PCIE_PROTOCOLERRORSTATUS_ADDR + PCIE_PROTOCOLERRORSTATUS_SIZE;
const UIntOrLong PCIE_LINKTRAININGSTATE_ADDR                        = PCIE_LINKWIDTHSTATUS_ADDR     + 1;
const UIntOrLong PCIE_DATALINKSTATE_ADDR                            = PCIE_LINKTRAININGSTATE_ADDR   + 1;
const UIntOrLong PCIE_DATALINKSTATUS_ADDR                           = PCIE_DATALINKSTATE_ADDR       + 1;

const UIntOrLong PCIE_VC_STATE_ADDR                                 = PCIE_DATALINKSTATUS_ADDR      + 1;
const UIntOrLong PCIE_LANESKEW_ADDR                                 = PCIE_VC_STATE_ADDR            + PCIE_VC_STATE_SIZE;

const UIntOrLong PCIE_HWCHANNEL_FUNCTION_PROP_ADDR                  = PCIE_LANESKEW_ADDR            + PCIE_LANESKEW_SIZE;
const UIntOrLong PCIE_HWCHANNELSTATUS_PROP_ADDR                     = PCIE_HWCHANNEL_FUNCTION_PROP_ADDR + ( PCIE_HWCHANNEL_FUNCTION_PROP_SIZE * PCIE_NUM_VCRESOURCES );

const UIntOrLong PCIE_PROBEBOARD_ID_ADDR                            = PCIE_HWCHANNELSTATUS_PROP_ADDR    + ( PCIE_HWCHANNELSTATUS_PROP_SIZE * PCIE_NUM_VCRESOURCES );
const UIntOrLong PCIE_PROBEBOARD_MODE_ADDR                          = PCIE_PROBEBOARD_ID_ADDR           + 4;

const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELA_ADDR                = PCIE_PROBEBOARD_MODE_ADDR                 + 1;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELB_ADDR                = PCIE_BLOCKLINESTART_HWCHANNELA_ADDR       + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELC_ADDR                = PCIE_BLOCKLINESTART_HWCHANNELB_ADDR       + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELD_ADDR                = PCIE_BLOCKLINESTART_HWCHANNELC_ADDR       + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELE_ADDR                = PCIE_BLOCKLINESTART_HWCHANNELD_ADDR       + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELBVF1_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELE_ADDR       + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELBVF2_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELBVF1_ADDR    + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELCVF1_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELBVF2_ADDR    + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELCVF2_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELCVF1_ADDR    + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELDVF1_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELCVF2_ADDR    + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELDVF2_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELDVF1_ADDR    + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELEVF1_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELDVF2_ADDR    + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNELEVF2_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELEVF1_ADDR    + PCIE_BLOCKLINE_NUM;
const UIntOrLong PCIE_BLOCKLINESTART_HWCHANNEL_END_ADDR             = PCIE_BLOCKLINESTART_HWCHANNELEVF2_ADDR    + PCIE_BLOCKLINE_NUM;

const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELA_ADDR               = PCIE_BLOCKLINESTART_HWCHANNEL_END_ADDR;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELB_ADDR               = PCIE_REQBEHLINESTART_HWCHANNELA_ADDR      + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELC_ADDR               = PCIE_REQBEHLINESTART_HWCHANNELB_ADDR      + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELD_ADDR               = PCIE_REQBEHLINESTART_HWCHANNELC_ADDR      + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELE_ADDR               = PCIE_REQBEHLINESTART_HWCHANNELD_ADDR      + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELBVF1_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELE_ADDR      + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELBVF2_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELBVF1_ADDR   + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELCVF1_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELBVF2_ADDR   + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELCVF2_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELCVF1_ADDR   + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELDVF1_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELCVF2_ADDR   + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELDVF2_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELDVF1_ADDR   + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELEVF1_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELDVF2_ADDR   + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNELEVF2_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELEVF1_ADDR   + PCIE_REQBEHLINE_NUM;
const UIntOrLong PCIE_REQBEHLINESTART_HWCHANNEL_END_ADDR            = PCIE_REQBEHLINESTART_HWCHANNELEVF2_ADDR   + PCIE_REQBEHLINE_NUM;

const UIntOrLong PCIE_COMPBEHLINESTART_QUEUEA_ADDR                  = PCIE_REQBEHLINESTART_HWCHANNEL_END_ADDR;  
const UIntOrLong PCIE_COMPBEHLINESTART_QUEUEB_ADDR                  = PCIE_COMPBEHLINESTART_QUEUEA_ADDR         + PCIE_COMPBEHLINE_NUM;
const UIntOrLong PCIE_COMPBEHLINESTART_QUEUEC_ADDR                  = PCIE_COMPBEHLINESTART_QUEUEB_ADDR         + PCIE_COMPBEHLINE_NUM;
const UIntOrLong PCIE_COMPBEHLINESTART_QUEUED_ADDR                  = PCIE_COMPBEHLINESTART_QUEUEC_ADDR         + PCIE_COMPBEHLINE_NUM;
const UIntOrLong PCIE_COMPBEHLINESTART_QUEUEE_ADDR                  = PCIE_COMPBEHLINESTART_QUEUED_ADDR         + PCIE_COMPBEHLINE_NUM;
const UIntOrLong PCIE_COMPBEHLINESTART_END_ADDR                     = PCIE_COMPBEHLINESTART_QUEUEE_ADDR         + PCIE_COMPBEHLINE_NUM;

const UIntOrLong PCIE_LINKUP_ADDR                                   = PCIE_COMPBEHLINESTART_END_ADDR            + PCIE_COMPBEHLINE_NUM;

const UIntOrLong PCIE_BLOCKLINEDEFAULTSET_ADDR                      = PCIE_LINKUP_ADDR + 1;

const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELA             = PCIE_BLOCKLINEDEFAULTSET_ADDR             + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELB             = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELA    + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELC             = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELB    + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELD             = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELC    + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELE             = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELD    + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELBVF1          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELE    + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELBVF2          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELBVF1 + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELCVF1          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELBVF2 + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELCVF2          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELCVF1 + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELDVF1          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELCVF2 + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELDVF2          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELDVF1 + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELEVF1          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELDVF2 + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELEVF2          = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELEVF1 + 1;
const UIntOrLong PCIE_BLOCKLINECOUNTGET_ADDR_END                    = PCIE_BLOCKLINECOUNTGET_ADDR_HWCHANNELEVF2;

const UIntOrLong PCIE_DLLPHY_PROP_ADDR                              = PCIE_BLOCKLINECOUNTGET_ADDR_END           + PCIE_BLOCKLINECOUNTGET_SIZE;

const UIntOrLong PCIE_BLOCKLINEDEFAULT_INSERT_ADDR                  = PCIE_DLLPHY_PROP_ADDR                     + PCIE_DLLPHY_PROP_SIZE;
const UIntOrLong PCIE_BLOCKLINEDELETE_ADDR                          = PCIE_BLOCKLINEDEFAULT_INSERT_ADDR         + 1;

const UIntOrLong PCIE_STATISTICSSTATUS_ADDR                         = PCIE_BLOCKLINEDELETE_ADDR                 + 1;

const UIntOrLong PCIE_REQBEHLINEDEFAULT_INSERT_ADDR                 = PCIE_STATISTICSSTATUS_ADDR + PCIE_STATISTICSSTATUS_SIZE;
const UIntOrLong PCIE_REQBEHLINEDELETE_ADDR                         = PCIE_REQBEHLINEDEFAULT_INSERT_ADDR + 1;
const UIntOrLong PCIE_REQBEHLINEDEFAULTSET_ADDR                     = PCIE_REQBEHLINEDELETE_ADDR + 1;


const UIntOrLong PCIE_REQBEHLINECOUNTGET_ADDR                       = PCIE_REQBEHLINEDEFAULTSET_ADDR + 1;

const UIntOrLong PCIE_COMPBEHLINEDEFAULT_INSERT_ADDR                = PCIE_REQBEHLINECOUNTGET_ADDR + PCIE_REQBEHLINECOUNTGET_SIZE;
const UIntOrLong PCIE_COMPBEHLINEDELETE_ADDR                        = PCIE_COMPBEHLINEDEFAULT_INSERT_ADDR + 1;
const UIntOrLong PCIE_COMPBEHLINEDEFAULTSET_ADDR                    = PCIE_COMPBEHLINEDELETE_ADDR + 1;


const UIntOrLong PCIE_COMPBEHLINECOUNTGET_ADDR                      = PCIE_COMPBEHLINEDEFAULTSET_ADDR + 1;

const UIntOrLong PCIE_INSTALLSWPACKAGE_ADDR                         = PCIE_COMPBEHLINECOUNTGET_ADDR + PCIE_COMPBEHLINECOUNTGET_SIZE;


const UIntOrLong PCIE_CHECKSWPACKAGE_ADDR                           = PCIE_INSTALLSWPACKAGE_ADDR + PCIE_INSTALLSWPACKAGE_SIZE;

const UIntOrLong PCIE_RUN_ADDR                                      = PCIE_CHECKSWPACKAGE_ADDR + PCIE_CHECKSWPACKAGE_SIZE;
const UIntOrLong PCIE_STOP_ADDR                                     = PCIE_RUN_ADDR + 1;
const UIntOrLong PCIE_RUN_FUNCTIONS_ADDR                            = PCIE_STOP_ADDR + 1;
const UIntOrLong PCIE_STOP_FUNCTIONS_ADDR                           = PCIE_RUN_FUNCTIONS_ADDR + PCIE_NUM_FUNCTIONS;

const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELA_ADDR               = PCIE_STOP_FUNCTIONS_ADDR                 + PCIE_NUM_FUNCTIONS;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELB_ADDR               = PCIE_EXERCISER_BLOCK_HWCHANNELA_ADDR     + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELC_ADDR               = PCIE_EXERCISER_BLOCK_HWCHANNELB_ADDR     + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELD_ADDR               = PCIE_EXERCISER_BLOCK_HWCHANNELC_ADDR     + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELE_ADDR               = PCIE_EXERCISER_BLOCK_HWCHANNELD_ADDR     + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELBVF1_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELE_ADDR     + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELBVF2_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELBVF1_ADDR  + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELCVF1_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELBVF2_ADDR  + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELCVF2_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELCVF1_ADDR  + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELDVF1_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELCVF2_ADDR  + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELDVF2_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELDVF1_ADDR  + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELEVF1_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELDVF2_ADDR  + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNELEVF2_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELEVF1_ADDR  + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_BLOCK_HWCHANNEL_END_ADDR            = PCIE_EXERCISER_BLOCK_HWCHANNELEVF2_ADDR;

const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELA_ADDR              = PCIE_EXERCISER_BLOCK_HWCHANNEL_END_ADDR   + PCIE_EXERCISER_BLOCK_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELB_ADDR              = PCIE_EXERCISER_REQBEH_HWCHANNELA_ADDR     + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELC_ADDR              = PCIE_EXERCISER_REQBEH_HWCHANNELB_ADDR     + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELD_ADDR              = PCIE_EXERCISER_REQBEH_HWCHANNELC_ADDR     + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELE_ADDR              = PCIE_EXERCISER_REQBEH_HWCHANNELD_ADDR     + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELBVF1_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELE_ADDR     + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELBVF2_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELBVF1_ADDR  + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELCVF1_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELBVF2_ADDR  + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELCVF2_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELCVF1_ADDR  + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELDVF1_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELCVF2_ADDR  + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELDVF2_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELDVF1_ADDR  + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELEVF1_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELDVF2_ADDR  + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNELEVF2_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELEVF1_ADDR  + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_REQBEH_HWCHANNEL_END_ADDR           = PCIE_EXERCISER_REQBEH_HWCHANNELEVF2_ADDR;

const UIntOrLong PCIE_EXERCISER_COMPBEH_QUEUE_0_ADDR                = PCIE_EXERCISER_REQBEH_HWCHANNEL_END_ADDR + PCIE_EXERCISER_REQBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_COMPBEH_QUEUE_1_ADDR                = PCIE_EXERCISER_COMPBEH_QUEUE_0_ADDR + PCIE_EXERCISER_COMPBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_COMPBEH_QUEUE_2_ADDR                = PCIE_EXERCISER_COMPBEH_QUEUE_1_ADDR + PCIE_EXERCISER_COMPBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_COMPBEH_QUEUE_3_ADDR                = PCIE_EXERCISER_COMPBEH_QUEUE_2_ADDR + PCIE_EXERCISER_COMPBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_COMPBEH_QUEUE_4_ADDR                = PCIE_EXERCISER_COMPBEH_QUEUE_3_ADDR + PCIE_EXERCISER_COMPBEH_SIZE;
const UIntOrLong PCIE_EXERCISER_COMPBEH_QUEUE_END_ADDR              = PCIE_EXERCISER_COMPBEH_QUEUE_4_ADDR ;

const UIntOrLong PCIE_BLOCK_GEN_DEFAULT_ADDR                        = PCIE_EXERCISER_COMPBEH_QUEUE_END_ADDR + PCIE_EXERCISER_COMPBEH_SIZE;
const UIntOrLong PCIE_REQBEH_GEN_DEFAULT_ADDR                       = PCIE_BLOCK_GEN_DEFAULT_ADDR + 1;
const UIntOrLong PCIE_COMPBEH_GEN_DEFAULT_ADDR                      = PCIE_REQBEH_GEN_DEFAULT_ADDR +1;

const UIntOrLong PCIE_LASTERROR_STRING_ADDR                         = PCIE_COMPBEH_GEN_DEFAULT_ADDR + 1;

const UIntOrLong PCIE_PROBEBOARD_SERIALSTRING_ADDR                  = PCIE_LASTERROR_STRING_ADDR + PCIE_LASTERROR_STRING_SIZE;

const UIntOrLong PCIE_STATISTICS_STATUS_CLEAR_ADDR                  = PCIE_PROBEBOARD_SERIALSTRING_ADDR + PCIE_PROBEBOARD_SERIALSTRING_SIZE;

const UIntOrLong PCIE_VCPROP_ADDR_HWCHANNELA                        = PCIE_STATISTICS_STATUS_CLEAR_ADDR + 1;
const UIntOrLong PCIE_VCPROP_ADDR_HWCHANNELB                        = PCIE_VCPROP_ADDR_HWCHANNELA + (PCIE_VC_NUM * PCIE_VCPROP_SIZE);
const UIntOrLong PCIE_VCPROP_ADDR_HWCHANNELC                        = PCIE_VCPROP_ADDR_HWCHANNELB + (PCIE_VC_NUM * PCIE_VCPROP_SIZE);
const UIntOrLong PCIE_VCPROP_ADDR_HWCHANNELD                        = PCIE_VCPROP_ADDR_HWCHANNELC + (PCIE_VC_NUM * PCIE_VCPROP_SIZE);
const UIntOrLong PCIE_VCPROP_ADDR_HWCHANNELE                        = PCIE_VCPROP_ADDR_HWCHANNELD + (PCIE_VC_NUM * PCIE_VCPROP_SIZE);
const UIntOrLong PCIE_VCPROP_ADDR_HWCHANNELEND                      = PCIE_VCPROP_ADDR_HWCHANNELE + (PCIE_VC_NUM * PCIE_VCPROP_SIZE);

const UIntOrLong PCIE_CONFIGSPACEPROP_ADDR                          = PCIE_VCPROP_ADDR_HWCHANNELEND;
const UIntOrLong PCIE_CONFIGSPACEPROP_FUNC_A_ADDR                   = PCIE_VCPROP_ADDR_HWCHANNELEND;
const UIntOrLong PCIE_CONFIGSPACEPROP_FUNC_B_ADDR                   = PCIE_CONFIGSPACEPROP_FUNC_A_ADDR + PCIE_CONFIGSPACEPROP_SIZE;
const UIntOrLong PCIE_CONFIGSPACEPROP_FUNC_C_ADDR                   = PCIE_CONFIGSPACEPROP_FUNC_B_ADDR + PCIE_CONFIGSPACEPROP_SIZE;
const UIntOrLong PCIE_CONFIGSPACEPROP_FUNC_D_ADDR                   = PCIE_CONFIGSPACEPROP_FUNC_C_ADDR + PCIE_CONFIGSPACEPROP_SIZE;
const UIntOrLong PCIE_CONFIGSPACEPROP_FUNC_E_ADDR                   = PCIE_CONFIGSPACEPROP_FUNC_D_ADDR + PCIE_CONFIGSPACEPROP_SIZE;
const UIntOrLong PCIE_CONFIGSPACEPROP_FUNC_END_ADDR                 = PCIE_CONFIGSPACEPROP_FUNC_E_ADDR + PCIE_CONFIGSPACEPROP_SIZE;

const UIntOrLong PCIE_HWCHANNEL_FUNCTION_STATUS_SNAPSHOT_ADDR       = PCIE_CONFIGSPACEPROP_FUNC_END_ADDR;

const UIntOrLong PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_SIZE          = PCIE_HWCHANNELSTATUS_PROP_SIZE;
const UIntOrLong PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_A_START_ADDR = PCIE_HWCHANNEL_FUNCTION_STATUS_SNAPSHOT_ADDR + 1;
const UIntOrLong PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_B_START_ADDR = PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_A_START_ADDR + PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_SIZE;
const UIntOrLong PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_C_START_ADDR = PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_B_START_ADDR + PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_SIZE;
const UIntOrLong PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_D_START_ADDR = PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_C_START_ADDR + PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_SIZE;
const UIntOrLong PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_E_START_ADDR = PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_D_START_ADDR + PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_SIZE;
const UIntOrLong PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_F_START_ADDR = PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_E_START_ADDR + PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_SIZE;

const UIntOrLong PCIE_LINKSTATE_DIRECT_ADDR                         = PCIE_HWCHANNEL_STATUS_ARRAY_HWCHANNEL_F_START_ADDR + PCIE_HWCHANNEL_FUNCTION_STATUS_ARRAY_SIZE; 

const UIntOrLong PCIE_RXERROR_ADDR                                  = PCIE_LINKSTATE_DIRECT_ADDR + PCIE_LINKSTATE_DIRECT_SIZE;
const UIntOrLong PCIE_RXERRORSTATUS_ADDR                            = PCIE_RXERROR_ADDR + PCIE_RXERROR_SIZE;

const UIntOrLong PCIE_FPGAINFO_ADDR                                 = PCIE_RXERRORSTATUS_ADDR + PCIE_RXERRORSTATUS_SIZE;

const UIntOrLong PCIE_RXERROR_CTRL_ADDR                             = PCIE_FPGAINFO_ADDR + PCIE_FPGAINFO_SIZE;

const UIntOrLong PCIE_EXERCISERSTATUS_ADDR                          = PCIE_RXERROR_CTRL_ADDR + 1;

const UIntOrLong PCIE_PERFORMANCE_COUNTER_STATUS_SNAPSHOT_ADDR      = PCIE_EXERCISERSTATUS_ADDR + PCIE_EXERCISERSTATUS_SIZE;
const UIntOrLong PCIE_PERFORMANCE_COUNTER_STATUS_RESET_ADDR         = PCIE_PERFORMANCE_COUNTER_STATUS_SNAPSHOT_ADDR + 1;
const UIntOrLong PCIE_PERFORMANCE_COUNTER_STATUS_PROP_START_ADDR    = PCIE_PERFORMANCE_COUNTER_STATUS_RESET_ADDR + 1;

const UIntOrLong PCIE_PATTERN_MASK_START_ADDR                       = PCIE_PERFORMANCE_COUNTER_STATUS_PROP_START_ADDR + (PCIE_PERFORMANCE_COUNTER_STATUS_PROP_SIZE * PCIE_TC_AND_LANE_NUM);
const UIntOrLong PCIE_PATTERN_VALUE_START_ADDR                      = PCIE_PATTERN_MASK_START_ADDR + (PCIE_NUM_OF_PATTERN_TERMS * PCIE_PATTERN_MASK_SIZE);
const UIntOrLong PCIE_PATTERN_STATUS_START_ADDR                     = PCIE_PATTERN_VALUE_START_ADDR + (PCIE_NUM_OF_PATTERN_TERMS * PCIE_PATTERN_VALUE_SIZE);
const UIntOrLong PCIE_PATTERN_STATUS_RESET_ADDR                     = PCIE_PATTERN_STATUS_START_ADDR + PCIE_NUM_OF_PATTERN_TERMS;
const UIntOrLong PCIE_PATTERN_RUNSTOP_ADDR                          = PCIE_PATTERN_STATUS_RESET_ADDR +1 ;
const UIntOrLong PCIE_PATTERN_DEFAULT_ADDR                          = PCIE_PATTERN_RUNSTOP_ADDR + 1;

const UIntOrLong PCIE_EXERCISER_STATUS_RESET_ADDR                   = PCIE_PATTERN_DEFAULT_ADDR + 1;
const UIntOrLong PCIE_EXERCISER_STATUS_SNAPSHOT_ADDR                = PCIE_EXERCISER_STATUS_RESET_ADDR + 1;

const UIntOrLong PCIE_EXERCISER_STATUS_RESET_FUNCTION_ADDR          = PCIE_EXERCISER_STATUS_SNAPSHOT_ADDR + 1;
const UIntOrLong PCIE_EXERCISER_STATUS_RESET_FUNCTION_ADDR_END      = PCIE_EXERCISER_STATUS_RESET_FUNCTION_ADDR + PCIE_NUM_FUNCTIONS;
const UIntOrLong PCIE_EXERCISER_STATUS_SNAPSHOT_FUNCTION_ADDR       = PCIE_EXERCISER_STATUS_RESET_FUNCTION_ADDR_END;
const UIntOrLong PCIE_EXERCISER_STATUS_SNAPSHOT_FUNCTION_ADDR_END   = PCIE_EXERCISER_STATUS_SNAPSHOT_FUNCTION_ADDR + PCIE_NUM_FUNCTIONS;

const UIntOrLong PCIE_MODULE_START_ADDR                             = PCIE_EXERCISER_STATUS_SNAPSHOT_FUNCTION_ADDR_END;

const UIntOrLong PCIE_SI_REQ_PYLD_DW_START_ADDR                     = PCIE_MODULE_START_ADDR + PCIE_MODULE_SIZE;
const UIntOrLong PCIE_SI_COMP_PYLD_DW_START_ADDR                    = PCIE_SI_REQ_PYLD_DW_START_ADDR + PCIE_SI_REQ_PYLD_DW_SIZE;

const UIntOrLong PCIE_PROBEBOARD_ADDR                               = PCIE_SI_COMP_PYLD_DW_START_ADDR + PCIE_SI_COMP_PYLD_DW_SIZE; 

const UIntOrLong PCIE_DUMMY_ADDR                                    = PCIE_PROBEBOARD_ADDR + PCIE_PROBEBOARD_SIZE;

const UIntOrLong PCIE_PROBEBOARDEXECUTE_ADDR                        = PCIE_DUMMY_ADDR + 1;

const UIntOrLong PCIE_TRIGGEROUTSET_ADDR                            = PCIE_PROBEBOARDEXECUTE_ADDR + PCIE_PROBEBOARDEXECUTE_SIZE;
const UIntOrLong PCIE_TRIGGEROUTGET_ADDR                            = PCIE_TRIGGEROUTSET_ADDR + PCIE_TRIGGEROUTSET_SIZE;
const UIntOrLong PCIE_TRIGGEROUTSTATUSREAD_ADDR                     = PCIE_TRIGGEROUTGET_ADDR + PCIE_TRIGGEROUTGET_SIZE;
const UIntOrLong PCIE_TRIGGEROUTSTATUSCLEAR_ADDR                    = PCIE_TRIGGEROUTSTATUSREAD_ADDR + PCIE_TRIGGEROUTSTATUSREAD_SIZE;

const UIntOrLong PCIE_SISTATUS_ADDR                                 = PCIE_TRIGGEROUTSTATUSCLEAR_ADDR + PCIE_TRIGGEROUTSTATUSCLEAR_SIZE;

// Protocol Checker
const UIntOrLong PCIE_PROTRULE_ACCU_ADDR                            = PCIE_SISTATUS_ADDR + PCIE_SISTATUS_SIZE;
const UIntOrLong PCIE_PROTRULE_FIRST_ADDR                           = PCIE_PROTRULE_ACCU_ADDR + PCIE_PROTRULE_ACCU_SIZE;
const UIntOrLong PCIE_PROTRULE_CLEAR_ADDR                           = PCIE_PROTRULE_FIRST_ADDR + PCIE_PROTRULE_FIRST_SIZE;
const UIntOrLong PCIE_PROTRULE_MASK_ADDR                            = PCIE_PROTRULE_CLEAR_ADDR + PCIE_PROTRULE_CLEAR_SIZE;
// Protocol VC errors 
const UIntOrLong PCIE_PROTRULE_VC_ACCU_ADDR                         = PCIE_PROTRULE_MASK_ADDR + PCIE_PROTRULE_MASK_SIZE;
const UIntOrLong PCIE_PROTRULE_VC_FIRST_ADDR                        = PCIE_PROTRULE_VC_ACCU_ADDR + PCIE_PROTRULE_VC_ACCU_SIZE;
const UIntOrLong PCIE_PROTRULE_VC_MASK_ADDR                         = PCIE_PROTRULE_VC_FIRST_ADDR + PCIE_PROTRULE_VC_FIRST_SIZE;
// Protocol function errors 
const UIntOrLong PCIE_PROTRULE_FUNCTION_ACCU_ADDR                   = PCIE_PROTRULE_VC_MASK_ADDR + PCIE_PROTRULE_VC_MASK_SIZE;
const UIntOrLong PCIE_PROTRULE_FUNCTION_FIRST_ADDR                  = PCIE_PROTRULE_FUNCTION_ACCU_ADDR + PCIE_PROTRULE_FUNCTION_ACCU_SIZE;
const UIntOrLong PCIE_PROTRULE_FUNCTION_MASK_ADDR                   = PCIE_PROTRULE_FUNCTION_FIRST_ADDR + PCIE_PROTRULE_FUNCTION_FIRST_SIZE;
const UIntOrLong PCIE_PROTRULE_RESERVED_ADDR                        = PCIE_PROTRULE_FUNCTION_MASK_ADDR + PCIE_PROTRULE_FUNCTION_MASK_SIZE;

const UIntOrLong PCIE_MODULEINFO_ADDR                               = PCIE_PROTRULE_RESERVED_ADDR + PCIE_PROTRULE_RESERVED_SIZE;

const UIntOrLong PCIE_ICACCESS_ADDR                                 = PCIE_MODULEINFO_ADDR + PCIE_MODULEINFO_SIZE;

const UIntOrLong PCIE_DLLP_PROP_ADDR                                = PCIE_ICACCESS_ADDR + PCIE_ICACCESS_SIZE;

const UIntOrLong PCIE_DLLP_STATUS_ADDR                              = PCIE_DLLP_PROP_ADDR + PCIE_DLLP_PROP_SIZE;

const UIntOrLong PCIE_DLLP_CONTROL_ADDR                             = PCIE_DLLP_STATUS_ADDR + PCIE_DLLP_STATUS_SIZE;

const UIntOrLong PCIE_DLLP_SEND_ADDR                                = PCIE_DLLP_CONTROL_ADDR + PCIE_DLLP_CONTROL_SIZE;

// This final entry (Gen 1) is needed for range checking in pciehwcontrol.cpp
const UIntOrLong PCIE_CMD_LASTADDR                                                = PCIE_DLLP_SEND_ADDR + 1;

const UIntOrLong PCIE_LANESKEW2_ADDR                                              = PCIE_CMD_LASTADDR + 1;

const UIntOrLong PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_LO_START_ADDR          = PCIE_LANESKEW2_ADDR + PCIE_LANESKEW2_SIZE;
const UIntOrLong PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_HI_START_ADDR          = PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_LO_START_ADDR           + PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_SIZE;

const UIntOrLong PCIE_PERFORMANCE_COUNTER_GEN3_VC_STATUS_PROP_LO_START_ADDR       = PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_HI_START_ADDR           + PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_SIZE;
const UIntOrLong PCIE_PERFORMANCE_COUNTER_GEN3_VC_STATUS_PROP_HI_START_ADDR       = PCIE_PERFORMANCE_COUNTER_GEN3_VC_STATUS_PROP_LO_START_ADDR        + PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_SIZE;

const UIntOrLong PCIE_PERFORMANCE_COUNTER_GEN3_FUNCTION_STATUS_PROP_LO_START_ADDR = PCIE_PERFORMANCE_COUNTER_GEN3_VC_STATUS_PROP_HI_START_ADDR        + PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_SIZE;
const UIntOrLong PCIE_PERFORMANCE_COUNTER_GEN3_FUNCTION_STATUS_PROP_HI_START_ADDR = PCIE_PERFORMANCE_COUNTER_GEN3_FUNCTION_STATUS_PROP_LO_START_ADDR  + PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_SIZE;

const UIntOrLong PCIE_LTSSM_MEMORY_IMAGE_START_ADDR                               = PCIE_PERFORMANCE_COUNTER_GEN3_FUNCTION_STATUS_PROP_HI_START_ADDR  + PCIE_PERFORMANCE_COUNTER_GEN3_STATUS_PROP_SIZE;

const UIntOrLong PCIE_LTSSM_DEFAULT_ADDR                                          = PCIE_LTSSM_MEMORY_IMAGE_START_ADDR  + PCIE_LTSSM_MEMORY_IMAGE_SIZE;
const UIntOrLong PCIE_LTSSM_LA_CONTROL_ADDR                                       = PCIE_LTSSM_DEFAULT_ADDR             + 1;
const UIntOrLong PCIE_LTSSM_LA_STATUS_ADDR                                        = PCIE_LTSSM_LA_CONTROL_ADDR          + PCIE_LTSSM_LA_CONTROL_SIZE;
const UIntOrLong PCIE_LTSSM_LA_ADDR                                               = PCIE_LTSSM_LA_STATUS_ADDR           + PCIE_LTSSM_LA_STATUS_SIZE;

// Capture Memory
const UIntOrLong PCIE_CAPTURE_ADDR                                                = PCIE_LTSSM_LA_ADDR + PCIE_LTSSM_LA_SIZE;
const UIntOrLong PCIE_CAPTURE_PATTPROG_ADDR                                       = PCIE_CAPTURE_ADDR;
const UIntOrLong PCIE_CAPTURE_PATTSET_ADDR                                        = PCIE_CAPTURE_PATTPROG_ADDR + PCIE_CAPTURE_PATTPROG_SIZE;
const UIntOrLong PCIE_CAPTURE_PATTGET_ADDR                                        = PCIE_CAPTURE_PATTSET_ADDR + PCIE_CAPTURE_PATTSET_SIZE;

const UIntOrLong PCIE_HOST_CONTROLLER_VERSION_ADDR                                = PCIE_CAPTURE_PATTGET_ADDR + PCIE_CAPTURE_PATTGET_SIZE;
const UIntOrLong PCIE_SERIAL_NUMBER_STRING_ADDR                                   = PCIE_HOST_CONTROLLER_VERSION_ADDR + PCIE_HOST_CONTROLLER_VERSION_SIZE;
const UIntOrLong PCIE_EXERCISERPHYSTATUS_ADDR                                     = PCIE_SERIAL_NUMBER_STRING_ADDR + PCIE_EXERCISERPHYSTATUS_SIZE;
const UIntOrLong PCIE_EXERCISERCHANNELFUNCTIONGET_ADDR                            = PCIE_EXERCISERPHYSTATUS_ADDR + PCIE_EXERCISERCHANNELFUNCTIONGET_SIZE;
const UIntOrLong PCIE_EXERCISERCHANNELFUNCTIONSET_ADDR                            = PCIE_EXERCISERCHANNELFUNCTIONGET_ADDR + PCIE_EXERCISERCHANNELFUNCTIONSET_SIZE;

// These are dummy addresses which are used for setting conf. function numbers so these are addeded in end
const UIntOrLong PCIE_CONFIGSPACE_FUNCNUM_A                                       = PCIE_EXERCISERCHANNELFUNCTIONSET_ADDR  + PCIE_EXERCISERCHANNELFUNCTIONSET_ADDR ;
const UIntOrLong PCIE_CONFIGSPACE_FUNCNUM_B                                       = PCIE_CONFIGSPACE_FUNCNUM_A      + 1;
const UIntOrLong PCIE_CONFIGSPACE_FUNCNUM_C                                       = PCIE_CONFIGSPACE_FUNCNUM_B      + 1;
const UIntOrLong PCIE_CONFIGSPACE_FUNCNUM_D                                       = PCIE_CONFIGSPACE_FUNCNUM_C      + 1;
const UIntOrLong PCIE_CONFIGSPACE_FUNCNUM_E                                       = PCIE_CONFIGSPACE_FUNCNUM_D      + 1;
const UIntOrLong PCIE_CONFIGSPACE_FUNCNUM_END                                     = PCIE_CONFIGSPACE_FUNCNUM_E;

const UIntOrLong PCIE_FT_ADDR                                                     = PCIE_CONFIGSPACE_FUNCNUM_END    + 1;

// Add more entries here !

//const UIntOrLong PCIE_ASYNCCALL_GET_CALL_STATUS_ADDR                              = PCIE_FT_ADDR + PCIE_FT_SIZE;
//const UIntOrLong PCIE_ASYNCCALL_RELEASE_CALLID_ADDR                               = PCIE_ASYNCCALL_GET_CALL_STATUS_ADDR + 1;
const UIntOrLong PCIE_DUT_CFGSPACE_START                                          = PCIE_FT_ADDR + PCIE_FT_SIZE;
const UIntOrLong PCIE_DUT_CFGSPACE_DEVID_BUSNUM_ADDR                              = PCIE_DUT_CFGSPACE_START;
const UIntOrLong PCIE_DUT_CFGSPACE_DEVID_DEVICENUM_ADDR                           = PCIE_DUT_CFGSPACE_START + 1;
const UIntOrLong PCIE_DUT_CFGSPACE_DEVID_FUNCTIONNUM_ADDR                         = PCIE_DUT_CFGSPACE_START + 2;
const UIntOrLong PCIE_DUT_CFGSPACE_DEVID_WRITE_ADDR                               = PCIE_DUT_CFGSPACE_START + 3;
const UIntOrLong PCIE_DUT_CFGSPACE_REG_READ_WRITE_ADDR                            = PCIE_DUT_CFGSPACE_START + 4;
const UIntOrLong PCIE_DUT_CFGSPACE_SCAN_DONE_ADDR                                 = PCIE_DUT_CFGSPACE_START + 5;
const UIntOrLong PCIE_DUT_CFGSPACE_SCAN_ADDR                                      = PCIE_DUT_CFGSPACE_START + 6;
const UIntOrLong PCIE_DUT_CFGSPACE_CAP_GET_COUNT_ADDR                             = PCIE_DUT_CFGSPACE_START + 7;
const UIntOrLong PCIE_DUT_CFGSPACE_CAP_GET_TYPEID_ADDR                            = PCIE_DUT_CFGSPACE_START + 8;
const UIntOrLong PCIE_DUT_CFGSPACE_CAP_GET_OFFSET_ADDR                            = PCIE_DUT_CFGSPACE_START + 9;
const UIntOrLong PCIE_DUT_CFGSPACE_CAP_GET_ISEXT_ADDR                             = PCIE_DUT_CFGSPACE_START + 10;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_CACHING_START_ADDR                        = PCIE_DUT_CFGSPACE_START + 11;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_CACHING_STOP_ADDR                         = PCIE_DUT_CFGSPACE_START + 12;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_TABLE_INIT_ADDR                           = PCIE_DUT_CFGSPACE_START + 13;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_TABLE_INIT_DONE_ADDR                      = PCIE_DUT_CFGSPACE_START + 14;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_TABLEENTRY_READ_WRITE_DW0_ADDR            = PCIE_DUT_CFGSPACE_START + 15;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_TABLEENTRY_READ_WRITE_DW1_ADDR            = PCIE_DUT_CFGSPACE_START + 16;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_TABLEENTRY_READ_WRITE_DW2_ADDR            = PCIE_DUT_CFGSPACE_START + 17;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_TABLEENTRY_READ_WRITE_DW3_ADDR            = PCIE_DUT_CFGSPACE_START + 18;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_PBA_REG_READ_WRITE_LO                     = PCIE_DUT_CFGSPACE_START + 19;
const UIntOrLong PCIE_DUT_CFGSPACE_MSIX_PBA_REG_READ_WRITE_HI                     = PCIE_DUT_CFGSPACE_START + 20;

const UIntOrLong PCIE_DUT_CFGSPACE_LAST                                           = PCIE_DUT_CFGSPACE_MSIX_PBA_REG_READ_WRITE_HI;

const UIntOrLong PCIE_NVME_SQ_PACKET_PROP_SIZE                                    = 30;
const UIntOrLong PCIE_NVME_CQ_PACKET_PROP_SIZE                                    = 10;

const UIntOrLong PCIE_NVME_START                                                  = PCIE_DUT_CFGSPACE_LAST + 1;
const UIntOrLong PCIE_NVME_CONTROLLER_RESET_ADDR                                  = PCIE_NVME_START;
const UIntOrLong PCIE_NVME_CONTREG_READ_WRITE_ADDR                                = PCIE_NVME_START + 1;
const UIntOrLong PCIE_NVME_PRPLIST_CREATE_ADDR                                    = PCIE_NVME_START + 2;
const UIntOrLong PCIE_NVME_PRPLIST_DELETE_ADDR                                    = PCIE_NVME_START + 3;
const UIntOrLong PCIE_NVME_PRPLIST_IN_USE_ADDR                                    = PCIE_NVME_START + 4;
const UIntOrLong PCIE_NVME_PRPLIST_ID_FOR_INDEX_ADDR                              = PCIE_NVME_START + 5;
const UIntOrLong PCIE_NVME_PRPLIST_INIT_DONE_ADDR                                 = PCIE_NVME_START + 6;
const UIntOrLong PCIE_NVME_PRPLIST_COUNT_ADDR                                     = PCIE_NVME_START + 7;
const UIntOrLong PCIE_NVME_PRPLIST_PROP_DEC_INDEX_ADDR                            = PCIE_NVME_START + 8;
const UIntOrLong PCIE_NVME_PRPLIST_PROP_PAGE_NUMBER_ADDR                          = PCIE_NVME_START + 9;
const UIntOrLong PCIE_NVME_PRPLIST_PROP_DATA_MEM_ADDR                             = PCIE_NVME_START + 10;
const UIntOrLong PCIE_NVME_PRPLIST_PROP_PHY_MEM_LO_ADDR                           = PCIE_NVME_START + 11;
const UIntOrLong PCIE_NVME_PRPLIST_PROP_PHY_MEM_HI_ADDR                           = PCIE_NVME_START + 12;
const UIntOrLong PCIE_NVME_PRPLIST_PROP_NUM_ENTRIES_ADDR                          = PCIE_NVME_START + 13;
const UIntOrLong PCIE_NVME_PRPLIST_ENTRY_DEC_INDEX_ADDR                           = PCIE_NVME_START + 14;
const UIntOrLong PCIE_NVME_PRPLIST_ENTRY_PAGE_NUMBER_ADDR                         = PCIE_NVME_START + 15;
const UIntOrLong PCIE_NVME_PRPLIST_ENTRY_OFFSET_ADDR                              = PCIE_NVME_START + 16;
const UIntOrLong PCIE_NVME_PRPLIST_ENTRY_DATA_MEM_ADDR                            = PCIE_NVME_START + 17;
const UIntOrLong PCIE_NVME_PRPLIST_ENTRY_PBAO_LO_ADDR                             = PCIE_NVME_START + 18;
const UIntOrLong PCIE_NVME_PRPLIST_ENTRY_PBAO_HI_ADDR                             = PCIE_NVME_START + 19;
const UIntOrLong PCIE_NVME_ADMIN_QUEUE_INIT_DONE_ADDR                             = PCIE_NVME_START + 20;
const UIntOrLong PCIE_NVME_ADMIN_SQ_INIT_ADDR                                     = PCIE_NVME_START + 21;
const UIntOrLong PCIE_NVME_ADMIN_CQ_INIT_ADDR                                     = PCIE_NVME_START + 22;
const UIntOrLong PCIE_NVME_SQ_DATA_MEM_ADDR                                       = PCIE_NVME_START + 23;
const UIntOrLong PCIE_NVME_CQ_DATA_MEM_ADDR                                       = PCIE_NVME_START + 24;
const UIntOrLong PCIE_NVME_SQ_PHY_MEM_HI_ADDR                                     = PCIE_NVME_START + 25;
const UIntOrLong PCIE_NVME_SQ_PHY_MEM_LO_ADDR                                     = PCIE_NVME_START + 26;
const UIntOrLong PCIE_NVME_CQ_PHY_MEM_HI_ADDR                                     = PCIE_NVME_START + 27;
const UIntOrLong PCIE_NVME_CQ_PHY_MEM_LO_ADDR                                     = PCIE_NVME_START + 28;
const UIntOrLong PCIE_NVME_SQ_CQ_ID_ADDR                                          = PCIE_NVME_START + 29;
const UIntOrLong PCIE_NVME_CQ_IV_ADDR                                             = PCIE_NVME_START + 30;
const UIntOrLong PCIE_NVME_SQ_COUNT_ADDR                                          = PCIE_NVME_START + 31;
const UIntOrLong PCIE_NVME_SQ_ID_FOR_INDEX_ADDR                                   = PCIE_NVME_START + 32;
const UIntOrLong PCIE_NVME_SQ_HEAD_ADDR                                           = PCIE_NVME_START + 33;
const UIntOrLong PCIE_NVME_SQ_TAIL_ADDR                                           = PCIE_NVME_START + 34;
const UIntOrLong PCIE_NVME_SQ_SIZE_ADDR                                           = PCIE_NVME_START + 35;
const UIntOrLong PCIE_NVME_SQ_PACKET_ADD_ADDR                                     = PCIE_NVME_START + 36;
const UIntOrLong PCIE_NVME_SQ_COMMIT_ADDR                                         = PCIE_NVME_START + 37;
const UIntOrLong PCIE_NVME_SQ_PACKET_COUNT_ADDR                                   = PCIE_NVME_START + 38;
const UIntOrLong PCIE_NVME_SQ_PACKET_PROP_START_ADDR                              = PCIE_NVME_START + 39;
const UIntOrLong PCIE_NVME_SQ_PACKET_PROP_END_ADDR                                = PCIE_NVME_SQ_PACKET_PROP_START_ADDR + PCIE_NVME_SQ_PACKET_PROP_SIZE;
const UIntOrLong PCIE_NVME_CQ_COUNT_ADDR                                          = PCIE_NVME_SQ_PACKET_PROP_END_ADDR + 1;
const UIntOrLong PCIE_NVME_CQ_ID_FOR_INDEX_ADDR                                   = PCIE_NVME_SQ_PACKET_PROP_END_ADDR + 2;
const UIntOrLong PCIE_NVME_CQ_HEAD_ADDR                                           = PCIE_NVME_SQ_PACKET_PROP_END_ADDR + 3;
const UIntOrLong PCIE_NVME_CQ_TAIL_ADDR                                           = PCIE_NVME_SQ_PACKET_PROP_END_ADDR + 4;
const UIntOrLong PCIE_NVME_CQ_SIZE_ADDR                                           = PCIE_NVME_SQ_PACKET_PROP_END_ADDR + 5;
const UIntOrLong PCIE_NVME_CQ_PACKET_COUNT_ADDR                                   = PCIE_NVME_SQ_PACKET_PROP_END_ADDR + 6;
const UIntOrLong PCIE_NVME_CQ_PACKET_PROP_START_ADDR                              = PCIE_NVME_SQ_PACKET_PROP_END_ADDR + 7;
const UIntOrLong PCIE_NVME_CQ_PACKET_PROP_END_ADDR                                = PCIE_NVME_CQ_PACKET_PROP_START_ADDR + PCIE_NVME_CQ_PACKET_PROP_SIZE;

const UIntOrLong PCIE_NVME_LAST                                                   = PCIE_NVME_CQ_PACKET_PROP_END_ADDR + 1;

// This final entry (Gen 2/3) is needed for range checking in Gen2 (pciehwcontrol.cpp)
const UIntOrLong PCIE_CMD_LASTADDR_GEN2                                           = PCIE_NVME_LAST + 1;

// TBD there should be an assertion, but it's very unlikely that the range 0x20000000-0x80000000 will
// be exceeded by the map above
const UIntOrLong PCIE_SPECIAL_ADDRESS_SPACE_START_ADDR                            = PCIE_DATAMEMSTART_ADDR;
const UIntOrLong PCIE_SPECIAL_ADDRESS_SPACE_END_ADDR                              = 0x80000000;

#endif /* DEVPCIEINTDEFS_H */